#include <iostream>
#include <vector>
#include <unordered_set>

int nzd(int a, int b)
{
	return b == 0 ? a : nzd(b, a % b); 
}

std::vector<int> divisors(int n)
{
	std::vector<int> ret;
	
	int i;
	for(i = 1; i * i < n; i++)
		if(n % i == 0)
			ret.push_back(i);
		
	if(i - (n / i) == 1)
		i--;
	
	for(; i >= 1; i--)
		if(n % i == 0)
			ret.push_back(n / i);
	
	return ret;
}

int main()
{
	int q;
	
	std::cin >> q;
	
	for(int i = 0; i < q; i++)
	{
		int n;
		std::cin >> n;
		
		std::unordered_set<int> unique;
		unique.insert(2);
		
		for(int j = 2; j < n; j++)
		{
			if(unique.size() >= n)
				break;
			
			int tmp = 2 * j;
			if(tmp > n)
				break;
			
			unique.insert(tmp);
		}
		
		for(int j = n - 1; j > 2; j--)
		{
			if(unique.size() >= n)
				break;
			
			auto search = unique.find(j);
			if(search != unique.end())
				continue;
			
			for(int card : unique)
			{
				if(nzd(card, j) > 1)
				{
					unique.insert(j);
					continue;
				}
			}
		}
		
		std::cout << unique.size() << "\n";
		
	}
	
	return 0;
}